<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Analytics extends CI_Controller {

	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('api_customers_model', 'customers');
		$this->load->database('default',true);
		date_default_timezone_set('Asia/Manila');
	}	

	 function logged_in($minutes=30){

	 
		 $this->db->select("api_accesscode");
		 $this->db->where("api_last_activity >", date( 'Y-m-d H:i:s',strtotime("- $minutes minutes") ));
		 $query = $this->db->get("api_sessions");
		 $result = $query->result();

		 header ("Content-Type:text/xml");
		 echo "<root>";
		 echo "<logged_in_users>" . $query->num_rows()  . "</logged_in_users>";
		 echo "<last_activity>" . $minutes  . " minute(s) </last_activity>";
		 echo "</root>";
	 }
 
	 function visitors($minutes=10,$date =false){

		 $this->db->select("ticket_session_id");
		 
		 $this->db->where("ticket_date_entered >", date( 'Y-m-d H:i:s',strtotime("- $minutes minutes") ));
		 
		 $ticket_session_query = $this->db->get("tickets");
		 		 
		 $ticket_session_query_result = $ticket_session_query->result();

		 $this->db->select("api_accesscode");
		 $this->db->where("api_last_activity >", date( 'Y-m-d H:i:s',strtotime("- $minutes minutes") ));
		 $api_session_query = $this->db->get("api_sessions");
		 $api_session_query_result = $api_session_query->result();
		 
		 $ticket_session_array  = array();
		 foreach($ticket_session_query_result as $ticket_session){
			 $ticket_session_array[] = $ticket_session->ticket_session_id;
 		 }
		 
		 
		 $api_session_array  = array();
		 foreach($api_session_query_result as $session_array){
			 $api_session_array[] = $session_array->api_accesscode;
 		 }
		 
		 
		 
		 $array = array_unique (array_merge ($api_session_array, $ticket_session_array));
		 

		 header ("Content-Type:text/xml");
		 echo "<root>";
		 echo "<active>" . count($array)  . "</active>";
		 echo "<logged_in>" . count($api_session_array)  . "</logged_in>";
		 echo "</root>";
		
		 
		 
	 } 
 
 
 
 	
 
  function visitors_2($date =false,$minutes = 15){
		

		if(!$date){
			$date = date('Y-m-d H:i:s');
		}
		
		
		$newTime = strtotime($date)- ($minutes * 60);
		
		$newTime = date('Y-m-d H:i:s', $newTime);
		
		 $this->db->select("ticket_session_id");
		 
		 $this->db->where("ticket_date_entered >", $newTime	);
		 
		 $ticket_session_query = $this->db->get("tickets");
		 
		 
		 // echo $this->db->last_query();
		 // die();
		 
		 $ticket_session_query_result = $ticket_session_query->result();

		 $this->db->select("api_accesscode");
		 $this->db->where("api_last_activity >", $newTime	);
		 $api_session_query = $this->db->get("api_sessions");
		 $api_session_query_result = $api_session_query->result();
		 
		 $ticket_session_array  = array();
		 foreach($ticket_session_query_result as $ticket_session){
			 $ticket_session_array[] = $ticket_session->ticket_session_id;
 		 }
		 
		 $api_session_array  = array();
		 foreach($api_session_query_result as $session_array){
			 $api_session_array[] = $session_array->api_accesscode;
 		 }
		 
		 $array = array_unique (array_merge ($api_session_array, $ticket_session_array));
		 

		// echo count($array);
		// die();
		return count($array);
	 } 
 
 
 
 
 
	 function hot($minutes=15, $qty = 5){
		 
		$date = date( 'Y-m-d H:i:s',strtotime("- $minutes minutes"));
		 
		// $this->db->select("events.event_title");
		// $this->db->where("ticket_date_entered >", date( 'Y-m-d H:i:s',strtotime("- $minutes minutes") ));
		// $this->db->join('prices', 'prices.price_id = tickets.ticket_price_id');
		// $this->db->join('events', 'events.event_id = prices.price_event_id');
		
		$query = $this->db->query("	SELECT count(`events`.`event_title`) as count,`events`.`event_title`
									FROM (`tickets`)
									JOIN `prices` ON `prices`.`price_id` = `tickets`.`ticket_price_id`
									JOIN `events` ON `events`.`event_id` = `prices`.`price_event_id`
									WHERE `ticket_date_entered` > '$date'
									group by `events`.`event_title`
									order by count desc	LIMIT $qty");
		
		$most_ticket_selected = $query->result();
		 
		 // echo "<pre>";
		 // print_r($most_ticket_selected);
		 // echo "</pre>";
		 // die();
		 
		 header ("Content-Type:text/xml");
		 echo "<root>";
		
				foreach($most_ticket_selected as $most_selected){
					echo "<event>" ;
					 // echo "<event>" ;
						echo "<selection_count>" . $most_selected->count . "</selection_count>";
						echo "<event_title>" . htmlentities($most_selected->event_title) . "</event_title>";
					 // echo "</event>" ;
					echo "</event>";
				}
		 
		 
		 
		 
		 
		 
		 
		 echo "</root>";
		 
		 
		 
	 }
 
 
 
 
 
	function loop($start_time,$interval = 15){

	date_default_timezone_set('Asia/Manila');
	$now = date ("Y-m-d H:i:s");

	// echo "-$start_time Hours";
	// die();
	
	$kanina = date ("Y-m-d H:i:s", strtotime("-$start_time Hours", strtotime($now)));
	$dates = false;
	$values = false;
	

	$count = 0;
	while (strtotime($kanina) <= strtotime($now)) {
		
		
		if($count != 1){
			$i =  $this->visitors_2($kanina);
			// echo $kanina. " " . $i  . "</br>";
		}else{

			$x = $this->visitors_2($kanina,$interval);
			echo  $kanina. " " .( $i - $x). "</br>";
			$i = $x;
		}
		
			$kanina = date ("Y-m-d H:i:s", strtotime("+$interval minutes", strtotime($kanina)));
			$count = 1;
				
	}
	
	
	

	 // die();
	}
 
 
 
 
	function loop_2($start_time,$interval = 15){

	date_default_timezone_set('Asia/Manila');
	$now = date ("Y-m-d H:i:s");

	// echo "-$start_time Hours";
	// die();
	
	$kanina = date ("H:i", strtotime("-$start_time Hours", strtotime($now)));
	
		$dates = false;
		$values = false;
	
	$count = 0;
	while (strtotime($kanina) <= strtotime($now)) {

		if($count != 1){
			$i =  $this->visitors_2($kanina);
			$dates = $dates . $kanina. " ";
			$values =  $values . $i . " ";
		}else{

			$x = $this->visitors_2($kanina);
			$dates = $dates . $kanina. " ";
			$values = $values . ( $i - $x)  . " "; 
			$i = $x;
		}
		
		
			$kanina = date ("H:i", strtotime("+$interval minutes", strtotime($kanina)));
			$count = 1;
				
	}
	
	
	echo $dates . "</br>";
	echo $values . "</br>";
	

	 // die();
	}
 
 
 
 

 
	function x(){
		$newTime = strtotime("2015-10-26 13:24:26 ");
		echo date('Y-m-d H:i:s', $newTime);
	}

 
 
 
}
